#include <stdio.h>
#include <stdlib.h>

struct elemento
{
    int info;
    struct elemento *next;
};

typedef struct elemento ElementoDiLista;
typedef ElementoDiLista *ListaDiElementi;

void InserimentoOrdinato(ListaDiElementi *lista, int elem);
void InserisciTesta(ListaDiElementi *lista, int elem);
void StampaLista(ListaDiElementi lis);

int main(void)
{
	printf("Ciao! Inserisci i tuoi elementi, io li ordinerò in modo crescente.\n");
	
    ListaDiElementi lista = NULL;

    int valoreDaInserire;

    while(valoreDaInserire >= 0)
    {
        scanf("%d", &valoreDaInserire);
        InserimentoOrdinato(&lista, valoreDaInserire);
    }

    StampaLista(lista);
    
	return 0;
}

void InserimentoOrdinato(ListaDiElementi *lista, int elem)
{
    if(*lista == NULL)
    {
        InserisciTesta(lista, elem);
    }
    else
    {
        if((*lista) -> info >= elem)
        {
            InserisciTesta(lista, elem);
        }
        else
        {
            InserimentoOrdinato(&((*lista)->next), elem);
        }
    }
}

void InserisciTesta(ListaDiElementi *lista, int elem)
{
    ListaDiElementi aux;
    aux = malloc(sizeof(ElementoDiLista));
    aux->info = elem;
    aux->next = *lista;
    *lista = aux;
}

void StampaLista(ListaDiElementi lis)
{
	if(lis != NULL)
	{
		printf("%d->", lis->info);
		StampaLista(lis->next);
	}
	else
	{
		printf("//");
	}
}